using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;


namespace MojaDrugaGraXNA
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class Prostopadloscian : Microsoft.Xna.Framework.DrawableGameComponent
    {
        private GraphicsDevice gd = null;
        private VertexBuffer buforWerteksow = null;

        private Effect efekt = null;
        public Matrix World = Matrix.Identity;
        private Matrix ViewProjection;

        public Prostopadloscian(Game game,Effect efekt,Matrix ViewProjection,float dx,float dy,float dz,Color? kolor)
            : base(game)
        {
            dx /= 2;
            dy /= 2;
            dz /= 2;

            gd = game.GraphicsDevice;

            //this.efekt = (BasicEffect)efekt.Clone();
            this.efekt = efekt.Clone();

            this.ViewProjection = ViewProjection;

            Vector3[] punkty = new Vector3[8]{
                new Vector3(-dx, -dy, dz),
                new Vector3(dx, -dy, dz),
                new Vector3(dx, dy, dz),
                new Vector3(-dx, dy, dz),
                new Vector3(-dx, -dy, -dz),
                new Vector3(dx, -dy, -dz),
                new Vector3(dx, dy, -dz),
                new Vector3(-dx, dy, -dz)};

            Vector2 t00 = Vector2.Zero;
            Vector2 t01 = Vector2.UnitY;
            Vector2 t10 = Vector2.UnitX;
            Vector2 t11 = Vector2.One;

            VertexPositionNormalTexture[] werteksy = new VertexPositionNormalTexture[6 * 4]{ //ZMIANA
                //przednia sciana
                new VertexPositionNormalTexture(punkty[3], Vector3.UnitZ, t00),
                new VertexPositionNormalTexture(punkty[2], Vector3.UnitZ, t01),
                new VertexPositionNormalTexture(punkty[0], Vector3.UnitZ, t10),
                new VertexPositionNormalTexture(punkty[1], Vector3.UnitZ, t11),

                //tylnia sciana
                new VertexPositionNormalTexture(punkty[7], -Vector3.UnitZ, t00),
                new VertexPositionNormalTexture(punkty[4], -Vector3.UnitZ, t01),
                new VertexPositionNormalTexture(punkty[6], -Vector3.UnitZ, t10),
                new VertexPositionNormalTexture(punkty[5], -Vector3.UnitZ, t11),
   
                //gorna sciana
                new VertexPositionNormalTexture(punkty[3], Vector3.UnitY, t00),
                new VertexPositionNormalTexture(punkty[7], Vector3.UnitY, t01),
                new VertexPositionNormalTexture(punkty[2], Vector3.UnitY, t10),
                new VertexPositionNormalTexture(punkty[6], Vector3.UnitY, t11),

                //dolna sciana
                new VertexPositionNormalTexture(punkty[0], -Vector3.UnitY, t00),
                new VertexPositionNormalTexture(punkty[1], -Vector3.UnitY, t01),
                new VertexPositionNormalTexture(punkty[4], -Vector3.UnitY, t10),
                new VertexPositionNormalTexture(punkty[5], -Vector3.UnitY, t11),
   
                //lewa sciana
                new VertexPositionNormalTexture(punkty[3], -Vector3.UnitX, t00),
                new VertexPositionNormalTexture(punkty[0], -Vector3.UnitX, t01),
                new VertexPositionNormalTexture(punkty[7], -Vector3.UnitX, t10),
                new VertexPositionNormalTexture(punkty[4], -Vector3.UnitX, t11),

                //prawa sciana
                new VertexPositionNormalTexture(punkty[1], Vector3.UnitX, t00),
                new VertexPositionNormalTexture(punkty[2], Vector3.UnitX, t01),
                new VertexPositionNormalTexture(punkty[5], Vector3.UnitX, t10),
                new VertexPositionNormalTexture(punkty[6], Vector3.UnitX, t11)};

            buforWerteksow = new VertexBuffer(gd, VertexPositionNormalTexture.VertexDeclaration, werteksy.Count(), BufferUsage.WriteOnly);
            buforWerteksow.SetData<VertexPositionNormalTexture>(werteksy);
        }

        /// <summary>
        /// Allows the game component to perform any initialization it needs to before starting
        /// to run.  This is where it can query for any required services and load content.
        /// </summary>
        public override void Initialize()
        {
            // TODO: Add your initialization code here

            base.Initialize();
        }

        /*
        public Matrix World
        {
            get
            {
                return efekt.World;
            }
            set
            {
                efekt.World = value;
            }
        }
        */

        /// <summary>
        /// Allows the game component to update itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        public override void Update(GameTime gameTime)
        {
            //efekt.World = World;
            efekt.Parameters["WVP"].SetValue(World * ViewProjection);
            efekt.Parameters["World"].SetValue(World);

            base.Update(gameTime);
        }

        public override void Draw(GameTime gameTime)
        {
            gd.SetVertexBuffer(buforWerteksow);
            
            foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
            {
                pass.Apply();
                
                //gd.DrawPrimitives(PrimitiveType.TriangleList, 0, 6 * 2);
                for(int i=0;i<6;++i)
                    gd.DrawPrimitives(PrimitiveType.TriangleStrip, 4*i, 2);
            }

            base.Draw(gameTime);
        }
    }
}